/************************************************************************
    Value_Added_API.h

    revision 1.2  2015-04-07  CSJ
    @ Change R_WRITE_SD_FAILED to R_WRITE_ISO_FAILED
    @ Added funcition instruction format

    revision 1.1  2015-04-07  CSJ
    @ Rename function name & data types

    version 1.0  2014-07-24  millieen
    @ Added UniToken Drive storage function
************************************************************************/
#ifndef _UMD_VALUE_ADDED_API_H_
#define _UMD_VALUE_ADDED_API_H_

#ifndef _UMD_RV_
#define _UMD_RV_
typedef unsigned long UMD_RV; 
#endif

#ifndef _UMD_HANDLE_
#define _UMD_HANDLE_
typedef unsigned long UMD_HANDLE;
#endif


#ifdef __cplusplus
extern "C" {
#endif

/* Function: initialize & find current devices' list
   Parameters:
             lpHandle:   [in] buffer area size. suggest 128(max device count founded one time)
                         [out] return handle list.
             deviceCount:[out] device count founded.
   Return Value: 
             Always R_OK
 */
UMD_RV UMD_Find(UMD_HANDLE* lpHandle, unsigned long* deviceCount);

/* Function: get total capacity
   Parameters:
             handle:    [in] handle of the target device.
             capacityMB:[out] the total capacity. unit: MB
   Return Value: 
             R_OK: successed
             R_NO_DEVICE: no device found.
             R_UNKNOW_ERROR: R/W failed many times.
 */
UMD_RV UMD_GetCapacity(UMD_HANDLE handle, unsigned long* capacityMB);

/* Function: Set the capacity of CD Partition & normal Partition
   Parameters:
             handle:    [in] handle of the target device
             CDSizeMB:  [in] the capacity want to set of CD Partition. unit: MB
             DiskSizeMB:[in] the capacity want to set of normal Partition. unit: MB
   Return Value: 
             R_OK: successed
             R_NO_DEVICE: no device found.
             R_UNKNOW_ERROR: R/W failed many times.
 */
UMD_RV UMD_SetPartition(UMD_HANDLE handle, unsigned long CDSizeMB, unsigned long DiskSizeMB);

/* Function: Get the capacity of CD Partition & normal Partition
   Parameters:
             handle:    [in] handle of the target device
             CDSizeMB:  [out] the capacity want to set of CD Partition. unit: MB
             DiskSizeMB:[out] the capacity want to set of normal Partition. unit: MB
   Return Value: 
             R_OK: successed
             R_NO_DEVICE: no device found.
             R_UNKNOW_ERROR: R/W failed many times.
 */
UMD_RV UMD_GetPartition(UMD_HANDLE handle, unsigned long* CDSizeMB, unsigned long* DiskSizeMB);

/* Function: Set a ISO image to CD Partition
   Parameters:
             handle:    [in] handle of the target device
             fileName:  [in] full path of the ISO image file
   Return Value: 
             R_OK: successed
             R_NO_DEVICE: no device found.
             R_UNKNOW_ERROR: R/W failed many times.
             R_ARGUMENTS_BAD: invalid ISO file.
             R_IMAGEFILE_TOO_BIG: ISO file size is out of the capacity of CD Partition
 */
UMD_RV UMD_WriteISO(UMD_HANDLE handle, char* fileName);

/* Function: Callback function. return the current process.
   Parameters:
             Type:     the type of current operation
             position: the process of current operation permillage (0~1000)
 */
#define STATUS_WRITEISO			0xa01
#define STATUS_FORMAT_STORAGE	0xa02
#define STATUS_PARTITION		0xa03
typedef int (* CALLBACKFUNC)(unsigned long Type, unsigned long position);
extern CALLBACKFUNC pfnCallback;	

#ifdef __cplusplus
}
#endif

//ERR CODE
#define R_OK							0x00
#define R_NO_DEVICE						0x01
#define R_ARGUMENTS_BAD					0x02
#define R_TIME_OUT						0x03
#define R_UNKNOW_ERROR					0x04
#define R_CHECK_SUM_ERROR				0x05
#define R_IMAGEFILE_TOO_BIG				0x06
#define R_VOLUMELETTER_BLANK			0x07
#define R_WRITE_ISO_FAILED				0x08

#endif // _UMD_VALUE_ADDED_API_H_